@echo off
title Restauration automatique WinPE
color 0A
setlocal EnableDelayedExpansion

echo.
echo =========================================
echo   RECHERCHE DES SAUVEGARDES DISPONIBLES
echo =========================================
echo.

set COUNT=0

for %%D in (C D E F G H I J K L M N O P Q R S T U V W Y Z) do (
    if exist %%D:\WindowsImageBackup (
        set /a COUNT+=1
        set "BACKUP!COUNT!=%%D:"
        echo  !COUNT! - Sauvegarde trouvee sur %%D:
    )
)

echo.

if %COUNT%==0 (
    echo [ERREUR] Aucune sauvegarde WindowsImageBackup trouvee.
    pause
    exit /b 1
)

if %COUNT%==1 (
    set "CHOICE=1"
    goto :getversion
)

:choose
set /p CHOICE=Numero de la sauvegarde ^> 
if not defined BACKUP%CHOICE% goto :choose

:getversion
set "SELECTED=!BACKUP%CHOICE%!"

echo.
echo Sauvegarde selectionnee : %SELECTED%
echo.

echo Recherche des versions disponibles...
wbadmin get versions -backupTarget:%SELECTED%

echo.
set /p VERSION=Copiez la Version exacte (MM/JJ/AAAA-HH:MM) ^> 

if "%VERSION%"=="" (
    echo Version invalide.
    pause
    exit /b 1
)

echo.
set /p CONFIRM=Confirmer la RESTAURATION COMPLETE ? (O/N) ^> 
if /I not "%CONFIRM%"=="O" exit /b 0

echo.
echo =========================================
echo   DEMARRAGE RESTAURATION SYSTEME
echo =========================================
echo.

wbadmin start sysrecovery ^
 -version:%VERSION% ^
 -backupTarget:%SELECTED% ^
 -recreateDisks ^
 -restoreAllVolumes ^
 -quiet

echo.
echo =========================================
echo   RESTAURATION TERMINEE
echo =========================================
echo.
pause
